package ga.core.evaluation;

import ga.core.individual.IIndividual;

/**
 * Listener for receiving notifications about the evaluation state.
 * 
 * @param <T>
 *          The generic type of the individuals.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public interface EvaluationListener<T extends IIndividual<T>> {
  /**
   * This will be notified when a evaluator demands a new individual for
   * evaluation.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public void newIndividualRequested();

  /**
   * This will be notified when an evaluator has evaluated the individual.
   * 
   * @param individual
   *          The individual that has been evaluated.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public void individualEvaluated(T individual);
}
